
; Define RC5 address of Remote Control

RemoteAddr	EQU	0x1D

;===============================================
; Definition of Functions on the Propeller clock

;Mnemonic	Code		; Funkci

STANDBY		EQU	0x0C	; Ki / be kapcsols

SEC_CL		EQU	0x62	; Msodperc trlse
SEC_UP		EQU	0x02	; Msodperc nvelse
SEC_DN		EQU	0x05	; Msodperc cskkentse
MIN_UP		EQU	0x14	; Perc nvelse
MIN_DN		EQU	0x15	; Perc cskkentse
HOUR_UP		EQU	0x12	; ra nvelse
HOUR_DN		EQU	0x13	; ra cskkentse
DAY_UP		EQU	0x01	; Nap nvelse
DAY_DN		EQU	0x04	; Nap cskkentse
MON_UP		EQU	0x03	; Hnap nvelse
MON_DN		EQU	0x06	; Hnap cskkentse
YEAR_UP		EQU	0x07	; v nvelse
YEAR_DN		EQU	0x0A	; v cskkentse
CENT_UP		EQU	0x6A	; vszzad nvelse
CENT_DN		EQU	0x6B	; vszzad cskkentse

INDEX_UP	EQU	0x31	; Offszet nvelse
INDEX_DN	EQU	0xb3	; Offszet cskkentse

BRIGHT_ST	EQU	0x5A	; Fnyer llts lpse : 1 / 16
BRIGHT_MD	EQU	0x5B	; Fnyer zemmd prgetse
BRIGHT_UP	EQU	0x5C	; Aktulis fnyer nvelse
BRIGHT_DN	EQU	0x5D	; Aktulis fnyer cskkentse

LIGHTLIM_UP	EQU	0x5E	; Megvilgts hatr nvelse
LIGHTLIM_DN	EQU	0x5F	; Megvilgts hatr cskkentse

TPICT		EQU	0x65	; Kpszm lptetse felfel
TPICTDN		EQU	0x63	; Kpszm lptetse lefel

TOuterLine	EQU	0x36	; Kls led llapotvlts
DigitalMode	EQU	0x0b	; Digitlis kijelzs zemmd vltsa
AnalogueMode	EQU	0x1d	; Analg mutatk lltsa
AnalogueHands	EQU	0x2d	; Analog kijelzs zemmd vltsa
AnalogClk	EQU	0x2a	; A bels ledeken megjelen ra kijelzs vltsa
						; - fellbrlja a msik analg kijelzst

DemoM		EQU	0x32	; Demo md vltsa
TextMode	EQU	0x22	; Mozg szveg zemmd vltsa
TStaticText	EQU	0x28	; Statikus kp zemmd vltsa
TWDayName	EQU 	0x00	; Ht napja szvegesen
SET_SP		EQU	0xb7	; Scroll sebessg nvelse
SET_SP_DN	EQU	0xb5	; Scroll sebessg cskkentse
LANGUAGE_U	EQU	0x08	; Nyelv kivlasztsa
LANGUAGE_D	EQU	0x61
TLANGUAGE	EQU	0x08	; Nyelv kivlasztsa
TBinMode	EQU	0x66	; Binris kijelzs vltsa
TTicks		EQU	0x34	; raoszts vltsa
TScrollMode	EQU	0xb0	; Scroll zemmd vltsa
TSlideShow	EQU	0x36	; Slide show zemmd vltsa

SAVE0		EQU	0x70	; Bellts mentse 0. helyre
RESTORE0	EQU	0x78	; Bellts visszalltsa 0. helyrl
SAVE1		EQU	0x71	; Bellts mentse 1. helyre
RESTORE1	EQU	0x79	; Bellts visszalltsa 1. helyrl
SAVE2		EQU	0x72	; Bellts mentse 2. helyre
RESTORE2	EQU	0x7A	; Bellts visszalltsa 2. helyrl
SAVE3		EQU	0x73	; Bellts mentse 3. helyre
RESTORE3	EQU	0x7B	; Bellts visszalltsa 3. helyrl
SAVE4		EQU	0x74	; Bellts mentse 4. helyre
RESTORE4	EQU	0x7C	; Bellts visszalltsa 4. helyrl
SAVE5		EQU	0x75	; Bellts mentse 5. helyre
RESTORE5	EQU	0x7D	; Bellts visszalltsa 5. helyrl
SAVE6		EQU	0x76	; Bellts mentse 6. helyre
RESTORE6	EQU	0x7E	; Bellts visszalltsa 6. helyrl
SAVE7		EQU	0x77	; Bellts mentse 7. helyre
RESTORE7	EQU	0x7F	; Bellts visszalltsa 7. helyrl

;===============================================
; Definition of Functions on the Propeller clock's Base

TINDEX		EQU	0x51	; Index led ki / bekapcsolsa
WIDTH_UP	EQU	0x52	; Impulzus szlessg nvelse
WIDTH_DN	EQU	0x53	; Impulzus szlessg cskkentse
REL_ON		EQU	0x54	; Rel kimenet bekapcsolsa
REL_OFF		EQU	0x55	; Rel kimenet kikapcsolsa
ALM_SND		EQU	0x0D	; bresztsi hangjelzs kikapcsolsa
POWUPCOIL	EQU	0x57	; Traf bekapcsolsa
POWDNCOIL	EQU	0x58	; Traf kikapcsolsa
